#!/bin/sh

# Script by eddie11c

#!/bin/sh

Tools="/Library/Application Support/OSx86 Tool/"
CustomImagePath="/Library/Application Support/OSx86 Tool/Custom/"
BackupPath="/Library/Application Support/OSx86 Tool/Original/"
DefaultImageName="MacOSX.tif"
DefaultImagePath="/System/Library/CoreServices/loginwindow.app/Contents/Resources/"
cd "${Tools}"
if [[ -d "${CustomImagePath}" ]]; then
	echo "Custom folder exists."
else
	mkdir "${CustomImagePath}"
fi
if [[ -d "${BackupPath}" ]]; then
	echo "Backup folder exists."
else
	mkdir "${BackupPath}"
fi
CustomImageName=$( cat imagepath.txt | Sed -n 1p )
echo "Custom Image is located at:${CustomImageName}"
Counter=""
while [[ -f "${BackupPath}${Counter}${DefaultImageName}" && -f "${BackupPath}${DefaultImageName}" ]]
do
	Counter=$(( ${Counter}+1 ))
done
cd "${CustomImagePath}"
sips -s format tiff "${CustomImageName}" --out "Temp.tif"
sips -z 124H 214W "Temp.tif" --out "${DefaultImageName}"
rm -Rf "${CustomImagePath}Temp.tif"
cp -R "${DefaultImagePath}${DefaultImageName}" "${BackupPath}${Counter}${DefaultImageName}"
echo "Backup copy located at:${BackupPath}${Counter}${DefaultImageName}"
cp -R "${CustomImagePath}${DefaultImageName}" "${DefaultImagePath}${DefaultImageName}"
rm -Rf "${CustomImagePath}${DefaultImageName}"
rm -Rf "${Tools}imagepath.txt"

exit 0

